/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.block;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizer;
import com.agricraft.agricraft.api.fertilizer.IAgriFertilizable;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.client.ClientUtil;
import com.agricraft.agricraft.common.block.CropState;
import com.agricraft.agricraft.common.block.CropStickVariant;
import com.agricraft.agricraft.common.block.SimpleFluidloggedBlock;
import com.agricraft.agricraft.common.block.entity.CropBlockEntity;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.item.CropSticksItem;
import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.common.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropBlock
extends class_2248
implements class_2343,
class_2256,
SimpleFluidloggedBlock {
    public static final class_265 SINGLE_STICKS = Stream.of(class_2248.method_9541((double)2.0, (double)-3.0, (double)2.0, (double)3.0, (double)14.0, (double)3.0), class_2248.method_9541((double)13.0, (double)-3.0, (double)2.0, (double)14.0, (double)14.0, (double)3.0), class_2248.method_9541((double)2.0, (double)-3.0, (double)13.0, (double)3.0, (double)14.0, (double)14.0), class_2248.method_9541((double)13.0, (double)-3.0, (double)13.0, (double)14.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    public static final class_265 CROSS_STICKS = Stream.of(SINGLE_STICKS, class_2248.method_9541((double)0.0, (double)11.0, (double)2.0, (double)16.0, (double)12.0, (double)3.0), class_2248.method_9541((double)0.0, (double)11.0, (double)13.0, (double)16.0, (double)12.0, (double)14.0), class_2248.method_9541((double)2.0, (double)11.0, (double)0.0, (double)3.0, (double)12.0, (double)16.0), class_2248.method_9541((double)13.0, (double)11.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    public static final class_265 CROP_STICKS = Stream.of(class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)14.0, (double)3.0), class_2248.method_9541((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)3.0), class_2248.method_9541((double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)14.0), class_2248.method_9541((double)13.0, (double)0.0, (double)13.0, (double)14.0, (double)14.0, (double)14.0)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    public static final class_2754<CropStickVariant> STICK_VARIANT = class_2754.method_11849((String)"variant", CropStickVariant.class, (Enum[])CropStickVariant.values());
    public static final class_2754<CropState> CROP_STATE = class_2754.method_11849((String)"crop", CropState.class, (Enum[])CropState.values());
    public static final class_2758 LIGHT = class_2758.method_11867((String)"light", (int)0, (int)16);
    private static final class_1799 BONE_MEAL = new class_1799((class_1935)class_1802.field_8324);

    public CropBlock() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_50012(class_3619.field_15971).method_26236((state, getter, pos) -> false).method_9640().method_22488().method_51370().method_45477().method_9631(blockState -> (Integer)blockState.method_11654((class_2769)LIGHT)).method_9626(class_2498.field_17580));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)SimpleFluidloggedBlock.LAVALOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SimpleFluidloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(STICK_VARIANT, (Comparable)((Object)CropStickVariant.WOODEN))).method_11657(CROP_STATE, (Comparable)((Object)CropState.SINGLE_STICKS))).method_11657((class_2769)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    public static void spawnItem(class_1937 level, class_2338 pos, class_1799 stack) {
        level.method_8649((class_1297)new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack));
    }

    public static class_1269 applyCropSticks(class_1937 level, class_2338 pos, class_2680 state, CropStickVariant variant) {
        if (variant == null) {
            return class_1269.field_5814;
        }
        if (level.method_8608()) {
            return class_1269.field_5811;
        }
        CropState cropState = (CropState)((Object)state.method_11654(CROP_STATE));
        class_2680 newState = state;
        if (cropState == CropState.PLANT) {
            newState = (class_2680)state.method_11657(CROP_STATE, (Comparable)((Object)CropState.PLANT_STICKS));
        } else if (cropState == CropState.SINGLE_STICKS && state.method_11654(STICK_VARIANT) == variant) {
            newState = (class_2680)state.method_11657(CROP_STATE, (Comparable)((Object)CropState.DOUBLE_STICKS));
        }
        if (newState == state) {
            return class_1269.field_5814;
        }
        level.method_8652(pos, newState, 3);
        if (cropState.hasSticks()) {
            variant.playSound(level, pos);
        } else {
            class_2498 sound = class_2246.field_10293.method_9573(class_2246.field_10293.method_9564());
            level.method_8396(null, pos, sound.method_10598(), class_3419.field_15245, (sound.method_10597() + 1.0f) / 2.0f, sound.method_10599() * 0.8f);
        }
        return class_1269.field_5812;
    }

    public static class_1271<CropStickVariant> removeCropSticks(class_1937 level, class_2338 pos, class_2680 state) {
        CropStickVariant stickVariant = (CropStickVariant)((Object)state.method_11654(STICK_VARIANT));
        if (level.method_8608()) {
            return class_1271.method_22430((Object)((Object)stickVariant));
        }
        CropState cropState = (CropState)((Object)state.method_11654(CROP_STATE));
        class_2680 newState = state;
        if (!cropState.hasPlant()) {
            newState = (class_2680)state.method_11657(CROP_STATE, (Comparable)((Object)CropState.SINGLE_STICKS));
        }
        if (newState == state) {
            return class_1271.method_22431((Object)((Object)stickVariant));
        }
        level.method_8652(pos, newState, 3);
        if (cropState == CropState.DOUBLE_STICKS) {
            stickVariant.playSound(level, pos);
        }
        return class_1271.method_22427((Object)((Object)stickVariant));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SimpleFluidloggedBlock.LAVALOGGED});
        builder.method_11667(new class_2769[]{SimpleFluidloggedBlock.WATERLOGGED});
        builder.method_11667(new class_2769[]{STICK_VARIANT});
        builder.method_11667(new class_2769[]{CROP_STATE});
        builder.method_11667(new class_2769[]{LIGHT});
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        CropState cropState = (CropState)((Object)state.method_11654(CROP_STATE));
        if (cropState == CropState.DOUBLE_STICKS) {
            return CROSS_STICKS;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CropBlockEntity) {
            CropBlockEntity cbe = (CropBlockEntity)class_25862;
            if (!cbe.hasPlant() && !cbe.hasWeeds()) {
                return SINGLE_STICKS;
            }
            return cropState.hasSticks() ? class_259.method_1072((class_265)CROP_STICKS, (class_265)cbe.getShape(), (class_247)class_247.field_1366) : cbe.getShape();
        }
        return super.method_9530(state, level, pos, context);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        CropState cropState = (CropState)((Object)state.method_11654(CROP_STATE));
        if (CoreConfig.cropSticksCollide && cropState.hasSticks()) {
            return cropState == CropState.DOUBLE_STICKS ? CROSS_STICKS : SINGLE_STICKS;
        }
        return class_259.method_1073();
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = this.method_9564();
        if (context.method_8045().method_8316(context.method_8037()).method_39360((class_3611)class_3612.field_15908)) {
            state = (class_2680)state.method_11657((class_2769)SimpleFluidloggedBlock.LAVALOGGED, (Comparable)Boolean.valueOf(true));
        } else if (context.method_8045().method_8316(context.method_8037()).method_39360((class_3611)class_3612.field_15910)) {
            state = (class_2680)state.method_11657((class_2769)SimpleFluidloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        class_1799 stack = context.method_8041();
        if (stack.method_7909() instanceof CropSticksItem) {
            state = this.blockStateCropStick(state, CropStickVariant.fromItem(stack));
        } else if (stack.method_7909() instanceof AgriSeedItem) {
            if (!CoreConfig.plantOffCropSticks) {
                return null;
            }
            state = this.blockStatePlant(state);
        }
        return state;
    }

    public class_2680 blockStateCropStick(class_2680 state, CropStickVariant variant) {
        return (class_2680)state.method_11657(STICK_VARIANT, (Comparable)((Object)variant));
    }

    public class_2680 blockStatePlant(class_2680 state) {
        return (class_2680)state.method_11657(CROP_STATE, (Comparable)((Object)CropState.PLANT));
    }

    @NotNull
    public class_3610 method_9545(class_2680 pState) {
        if (((Boolean)pState.method_11654((class_2769)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
            return class_3612.field_15908.method_15729(false);
        }
        if (((Boolean)pState.method_11654((class_2769)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(pState);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return Platform.get().createCropBlockEntity(pos, state);
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        Optional<class_1269> override;
        class_1269 result;
        Optional<AgriCrop> optional = AgriApi.getCrop((class_1922)level, pos);
        if (optional.isEmpty()) {
            return class_1269.field_5814;
        }
        AgriCrop crop = optional.get();
        if (crop.hasPlant() && (result = crop.getPlant().onRightClickPre(crop, player.method_5998(hand), (class_1297)player)).isPresent()) {
            return (class_1269)result.get();
        }
        result = this.rightClickLogic(player.method_5998(hand), state, level, pos, player, hand, crop);
        if (crop.hasPlant() && (override = crop.getPlant().onRightClickPost(crop, player.method_5998(hand), (class_1297)player)).isPresent()) {
            return override.get();
        }
        return result;
    }

    protected class_1269 rightClickLogic(class_1799 heldItem, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, AgriCrop crop) {
        class_1269 result;
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        if (heldItem.method_31574((class_1792)ModItems.CLIPPER.get()) || heldItem.method_31574((class_1792)ModItems.IRON_RAKE.get()) || heldItem.method_31574((class_1792)ModItems.WOODEN_RAKE.get())) {
            return class_1269.field_5811;
        }
        if (AgriApi.getFertilizerAdapter(heldItem).isPresent()) {
            return AgriApi.getFertilizerAdapter(heldItem).get().valueOf(heldItem).map(fertilizer -> {
                if (crop.acceptsFertilizer((AgriFertilizer)fertilizer)) {
                    class_1269 result = fertilizer.applyFertilizer(level, pos, crop, heldItem, level.field_9229, (class_1309)player);
                    if (result == class_1269.field_21466 || result == class_1269.field_5812) {
                        crop.onApplyFertilizer((AgriFertilizer)fertilizer, level.field_9229);
                        if (crop.hasPlant()) {
                            crop.getPlant().onFertilized(crop, heldItem, level.field_9229);
                        }
                    }
                    return result;
                }
                return class_1269.field_21466;
            }).orElse(class_1269.field_5811);
        }
        if (heldItem.method_7909() instanceof CropSticksItem && (result = CropBlock.applyCropSticks(level, pos, state, CropStickVariant.fromItem(heldItem))) == class_1269.field_5812) {
            if (!player.method_7337()) {
                player.method_5998(hand).method_7934(1);
            }
            return result;
        }
        Optional genome = AgriApi.getGenomeAdapter(heldItem).flatMap(adapter -> adapter.valueOf(heldItem));
        if (genome.isPresent()) {
            if (!crop.isCrossCropSticks() && !crop.hasPlant()) {
                crop.plantGenome((AgriGenome)genome.get());
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (crop.isCrossCropSticks()) {
            class_1271<CropStickVariant> result2 = CropBlock.removeCropSticks(level, pos, state);
            if (result2.method_5467() == class_1269.field_5812) {
                if (!player.method_7337()) {
                    CropBlock.spawnItem(level, pos, CropStickVariant.toItem((CropStickVariant)((Object)result2.method_5466())));
                }
                return class_1269.field_21466;
            }
        } else if (crop.hasPlant() && crop.canBeHarvested()) {
            crop.harvest(itemStack -> CropBlock.spawnItem(level, pos, itemStack), (class_1309)player);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @NotNull
    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)class_25862;
            if (crop.hasPlant()) {
                return AgriSeedItem.toStack(crop.getGenome());
            }
            if (crop.hasCropSticks()) {
                return CropStickVariant.toItem((CropStickVariant)((Object)state.method_11654(STICK_VARIANT)));
            }
        }
        return super.method_9574(level, pos, state);
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
        this.spawnDestroyParticles((class_1936)level, state, pos);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15908, class_3612.field_15908.method_15789((class_4538)level));
        } else if (((Boolean)state.method_11654((class_2769)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (!state.method_26184((class_4538)level, pos)) {
            this.spawnDestroyParticles(level, state, pos);
            if (((Boolean)state.method_11654((class_2769)SimpleFluidloggedBlock.LAVALOGGED)).booleanValue()) {
                return class_3612.field_15908.method_15785().method_15759();
            }
            if (((Boolean)state.method_11654((class_2769)SimpleFluidloggedBlock.WATERLOGGED)).booleanValue()) {
                return class_3612.field_15910.method_15785().method_15759();
            }
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return AgriApi.getSoil((class_1922)level, pos.method_10074(), level.method_30349()).isPresent();
    }

    public boolean method_9651(class_4538 level, class_2338 pos, class_2680 state, boolean isClient) {
        return AgriApi.getCrop((class_1922)level, pos).map(crop -> crop.hasPlant() && crop.isFertile() && !crop.isFullyGrown()).orElse(false);
    }

    public boolean method_9650(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        return AgriApi.getFertilizer(BONE_MEAL).flatMap(fertilizer -> AgriApi.getCrop((class_1922)level, pos).map(crop -> !crop.isFullyGrown() && crop.acceptsFertilizer((AgriFertilizer)fertilizer))).orElse(false);
    }

    public void method_9652(class_3218 level, class_5819 random, class_2338 pos, class_2680 state) {
        AgriApi.getFertilizer(BONE_MEAL).ifPresent(fertilizer -> AgriApi.getCrop((class_1922)level, pos).ifPresent(crop -> fertilizer.applyFertilizer((class_1937)level, pos, (IAgriFertilizable)crop, BONE_MEAL, random, null)));
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (state.method_11654(STICK_VARIANT) == CropStickVariant.WOODEN && level.method_8316(pos).method_39360((class_3611)class_3612.field_15908)) {
            this.spawnDestroyParticles((class_1936)level, state, pos);
            level.method_22352(pos, true);
            return;
        }
        AgriApi.getCrop((class_1922)level, pos).ifPresent(agriCrop -> {
            if (agriCrop.hasPlant()) {
                agriCrop.getPlant().onRandomTick((AgriCrop)agriCrop, random);
            }
            agriCrop.applyGrowthTick();
        });
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        AgriApi.getCrop((class_1922)level, pos).ifPresent(crop -> {
            if (crop.hasPlant()) {
                crop.getPlant().spawnParticles((AgriCrop)crop, random);
            }
        });
    }

    public void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        AgriApi.getCrop((class_1922)level, pos).ifPresent(crop -> {
            if (crop.hasPlant()) {
                crop.getPlant().onBroken((AgriCrop)crop, (class_1309)player);
            }
        });
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        class_2586 tile = (class_2586)params.method_51876(class_181.field_1228);
        if (tile == null) {
            return drops;
        }
        CropState cropState = (CropState)((Object)state.method_11654(CROP_STATE));
        if (cropState.hasSticks()) {
            drops.add(CropStickVariant.toItem((CropStickVariant)((Object)state.method_11654(STICK_VARIANT)), cropState == CropState.DOUBLE_STICKS ? 2 : 1));
        }
        if (tile instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)tile;
            crop.getHarvestProducts(drops::add);
            if (crop.hasPlant() && (crop.isFullyGrown() || !CoreConfig.onlyMatureSeedDrops)) {
                drops.add(AgriSeedItem.toStack(crop.getGenome()));
            }
        }
        return drops;
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        super.method_9548(state, level, pos, entity);
        AgriApi.getCrop((class_1922)level, pos).ifPresent(crop -> {
            if (crop.hasPlant()) {
                crop.getPlant().onEntityCollision((AgriCrop)crop, entity);
            }
        });
    }

    public boolean method_9506(class_2680 state) {
        return ((CropState)((Object)state.method_11654(CROP_STATE))).hasPlant();
    }

    public boolean method_9498(class_2680 state) {
        return ((CropState)((Object)state.method_11654(CROP_STATE))).hasPlant();
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return super.method_9603(state, (class_1922)level, pos, null);
    }

    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return this.method_9603(state, level, pos, direction);
    }

    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return ((CropState)((Object)state.method_11654(CROP_STATE))).hasPlant() ? AgriApi.getCrop(level, pos).map(crop -> {
            if (crop.getPlant() != null) {
                return crop.getPlant().getRedstonePower((AgriCrop)crop);
            }
            return 0;
        }).orElse(0) : 0;
    }

    private void spawnDestroyParticles(class_1936 level, class_2680 state, class_2338 pos) {
        class_2586 class_25862;
        if (level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)class_25862;
            CropState cropState = (CropState)((Object)state.method_11654(CROP_STATE));
            if (cropState.hasSticks()) {
                if (cropState == CropState.DOUBLE_STICKS) {
                    ClientUtil.spawnParticlesForSticks((CropStickVariant)((Object)state.method_11654(STICK_VARIANT)), level, state, pos, CROSS_STICKS);
                } else {
                    ClientUtil.spawnParticlesForSticks((CropStickVariant)((Object)state.method_11654(STICK_VARIANT)), level, state, pos, SINGLE_STICKS);
                }
            }
            if (crop.hasPlant()) {
                String plantModelId = crop.getPlantId().replace(":", ":crop/") + "_stage" + crop.getGrowthStage().index();
                class_2586 class_25863 = level.method_8321(pos);
                if (class_25863 instanceof CropBlockEntity) {
                    CropBlockEntity cbe = (CropBlockEntity)class_25863;
                    ClientUtil.spawnParticlesForPlant(plantModelId, level, state, pos, cbe.getShape());
                }
            }
        }
    }
}

